/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.MinionPower;
import com.megacrit.cardcrawl.powers.StrengthPower;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SummonGremlinAction
extends AbstractGameAction {
    private static final Logger logger = LogManager.getLogger(SummonGremlinAction.class.getName());
    private static final float DURATION = 1.0f;
    private AbstractMonster m;
    private int slotToFill = 0;

    public SummonGremlinAction(AbstractMonster[] gremlins) {
        this.actionType = AbstractGameAction.ActionType.SPECIAL;
        this.duration = 1.0f;
        int slot = this.identifySlot(gremlins);
        if (slot == -1) {
            logger.info("INCORRECTLY ATTEMPTED TO SUMMON GREMLIN.");
            return;
        }
        this.slotToFill = slot;
        gremlins[slot] = this.m = this.getRandomGremlin(slot);
        if (AbstractDungeon.player.hasRelic("Philosopher's Stone")) {
            this.m.addPower(new StrengthPower(this.m, 2));
        }
    }

    private int identifySlot(AbstractMonster[] gremlins) {
        for (int i = 0; i < gremlins.length; ++i) {
            if (gremlins[i] != null && !gremlins[i].isDying) continue;
            return i;
        }
        return -1;
    }

    private AbstractMonster getRandomGremlin(int slot) {
        float y;
        float x;
        ArrayList<String> pool = new ArrayList<String>();
        pool.add("GremlinWarrior");
        pool.add("GremlinWarrior");
        pool.add("GremlinThief");
        pool.add("GremlinThief");
        pool.add("GremlinFat");
        pool.add("GremlinFat");
        pool.add("GremlinTsundere");
        pool.add("GremlinWizard");
        switch (slot) {
            case 0: {
                x = -366.0f;
                y = -4.0f;
                break;
            }
            case 1: {
                x = -170.0f;
                y = 6.0f;
                break;
            }
            case 2: {
                x = -532.0f;
                y = 0.0f;
                break;
            }
            default: {
                x = -366.0f;
                y = -4.0f;
            }
        }
        return MonsterHelper.getGremlin((String)pool.get(MathUtils.random(0, pool.size() - 1)), x, y);
    }

    @Override
    public void update() {
        if (this.duration == 1.0f) {
            this.m.animX = 1200.0f * Settings.scale;
            this.m.init();
            this.m.applyPowers();
            AbstractDungeon.getCurrRoom().monsters.addMonster(this.slotToFill, this.m);
            if (DailyMods.mods.get("Lethal Enemies").booleanValue()) {
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this.m, this.m, new StrengthPower(this.m, 3), 3));
            }
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this.m, this.m, new MinionPower(this.m)));
        }
        this.tickDuration();
        if (this.isDone) {
            this.m.animX = 0.0f;
            this.m.showHealthBar();
            this.m.usePreBattleAction();
        } else {
            this.m.animX = Interpolation.fade.apply(0.0f, 1200.0f * Settings.scale, this.duration);
        }
    }
}

